-- Copyright 2024-2025 by Todd Hundersmarck (ThundR) 
-- All Rights Reserved

--[[

Unauthorized use and/or distribution of this work entitles myself, the author, to unlimited free and unrestricted use, access, and distribution of any works related to the unauthorized user and/or distributor.

--]]

local g_thModName = g_currentModName
_G.THSpecType = {
    VEHICLE = 1,
    PLACEABLE = 2
}
THSpecManager = {}
local THSpecManager_mt = Class(THSpecManager)
THSpecManager.CLASS_NAME = "THSpecManager"
local function initScript()
    local self = THSpecManager.new()
    if self ~= nil then
        _G.g_thSpecManager = self
    end
end
function THSpecManager.new(customMt)
    customMt = customMt or THSpecManager_mt
    if THUtils.argIsValid(type(customMt) == THValueType.TABLE, "customMt", customMt) then
        local self = setmetatable({}, customMt)
        self.specTypes = {
            byIndex = {},
            byName = {}
        }
        for specTypeName, specTypeIndex in pairs(THSpecType) do
            local specTypeData = {
                name = specTypeName,
                index = specTypeIndex
            }
            local isSpecTypeValid = true
            if specTypeIndex == THSpecType.VEHICLE then
                specTypeData.title = "vehicle"
                specTypeData.titlePlural = "vehicles"
                specTypeData.manager = g_thGlobalEnv.g_specializationManager
            elseif specTypeIndex == THSpecType.PLACEABLE then
                specTypeData.title = "placeable"
                specTypeData.titlePlural = "placeables"
                specTypeData.manager = g_thGlobalEnv.g_placeableSpecializationManager
            else
                isSpecTypeValid = false
            end
            if isSpecTypeValid then
                self.specTypes.byIndex[specTypeIndex] = specTypeData
                self.specTypes.byName[specTypeName] = specTypeData
            end
        end
        THUtils.prependFunction("TypeManager", "finalizeTypes", false, false, self, THSpecManager.prepend_finalizeTypes)
        return self
    end
end
function THSpecManager.prepend_finalizeTypes(self, superFunc, parent)
    local specTypeData = self.specTypes.byName[parent.typeName:upper()]
    if specTypeData ~= nil then
        local specsArray = specTypeData.manager.sortedSpecializations
        local typedObjects = parent:getTypes()
        if specsArray ~= nil and typedObjects ~= nil then
            for specIndex = 1, #specsArray do
                local specDesc = specsArray[specIndex]
                if specDesc.name ~= nil
                    and string.find(specDesc.name, "^" .. g_thModName)
                then
                    local specClass = specTypeData.manager:getSpecializationObjectByName(specDesc.name)
                    if specClass ~= nil then
                        local timesAdded = 0
                        for objectTypeName, objectType in pairs(typedObjects) do
                            if objectType.specializations ~= nil
                                and not SpecializationUtil.hasSpecialization(specClass, objectType.specializations)
                                and specClass.prerequisitesPresent(objectType.specializations)
                            then
                                parent:addSpecialization(objectTypeName, specDesc.name)
                                if SpecializationUtil.hasSpecialization(specClass, objectType.specializations) then
                                    timesAdded = timesAdded + 1
                                end
                            end
                        end
                        if timesAdded > 0 then
                            THUtils.displayMsg("Specialization %q added to %d %s", specDesc.name, timesAdded, specTypeData.titlePlural)
                        end
                    end
                end
            end
        end
    end
end
THUtils.pcall(initScript)