-- Copyright 2024-2025 by Todd Hundersmarck (ThundR) 
-- All Rights Reserved

--[[

Unauthorized use and/or distribution of this work entitles myself, the author, to unlimited free and unrestricted use, access, and distribution of any works related to the unauthorized user and/or distributor.

--]]

local THLoadingStation = {}
THSprayTypes.LoadingStation = THLoadingStation
local THBuyingStation = {}
THSprayTypes.BuyingStation = THBuyingStation
local THLoadTrigger = {}
THSprayTypes.LoadTrigger = THLoadTrigger
local function initScript()
    THUtils.setFunctionHook("LoadingStation", "load", false, false, nil, THLoadingStation.gInj_load)
    THUtils.setFunctionHook("BuyingStation", "load", false, false, nil, THBuyingStation.gInj_load)
    THUtils.setFunctionHook("LoadTrigger", "load", false, false, nil, THLoadTrigger.gInj_load)
end
function THLoadingStation.gInj_load(superFunc, parent, rootNode, xmlFile, xmlKey, ...)
    THUtils.pcall(function()
        local wrappedXML = THUtils.wrapXMLFile(xmlFile)
        if wrappedXML ~= nil then
            local fillTypeNames = wrappedXML:getString(xmlKey .. "#fillTypes")
            local fillTypeCategories = wrappedXML:getString(xmlKey .. "#fillTypeCategories")
            if (fillTypeNames ~= nil and fillTypeNames ~= "")
                or (fillTypeCategories ~= nil and fillTypeCategories ~= "")
            then
                local newFillTypeNames = g_thSprayTypes:addExtendedSprayTypesToFillTypeList(fillTypeNames, fillTypeCategories, nil, true, true)
                if newFillTypeNames ~= nil then
                    if THUtils.getIsDebugEnabled() then
                        THUtils.displayMsg("LoadingStation: updated fill types: %s", newFillTypeNames)
                    end
                    wrappedXML:setString(xmlKey .. "#fillTypes", newFillTypeNames)
                    if fillTypeCategories ~= nil then
                        wrappedXML:removeProperty(xmlKey .. "#fillTypeCatgories")
                    end
                end
            end
        end
    end)
    return superFunc(parent, rootNode, xmlFile, xmlKey, ...)
end
function THBuyingStation.gInj_load(superFunc, parent, rootNode, xmlFile, xmlKey, ...)
    THUtils.pcall(function()
        local wrappedXML = THUtils.wrapXMLFile(xmlFile)
        if wrappedXML ~= nil then
            local stationFillTypes = {}
            local lastFillTypeXMLIndex = 0
            local defaultPriceScale, defaultStatsName = nil, nil
            wrappedXML:iterate(xmlKey .. "fillTypes.fillType", function(pFillTypeXMLIndex, pFillTypeKey)
                local fillTypeName = wrappedXML:getString(pFillTypeKey .. "#name")
                local priceScale = wrappedXML:getFloat(pFillTypeKey .. "#priceScale")
                local statsName = wrappedXML:getString(pFillTypeKey .. "#statsName")
                if fillTypeName ~= nil and fillTypeName ~= "" then
                    local thFillTypeData = g_thMapTypeManager:getFillType(fillTypeName)
                    local xtSprayTypeData = g_thSprayTypes:getExtendedSprayType(fillTypeName)
                    if thFillTypeData ~= nil and thFillTypeData ~= FillType.UNKNOWN
                        and (statsName ~= nil or priceScale ~= nil)
                    then
                        if priceScale ~= nil then
                            if defaultPriceScale == nil or xtSprayTypeData ~= nil then
                                defaultPriceScale = priceScale
                            end
                        end
                        if statsName ~= nil then
                            if defaultStatsName == nil or xtSprayTypeData ~= nil then
                                defaultStatsName = statsName
                            end
                        end
                        stationFillTypes[thFillTypeData.name] = {
                            priceScale = priceScale,
                            statsName = statsName
                        }
                    end
                end
                lastFillTypeXMLIndex = math.max(lastFillTypeXMLIndex, pFillTypeXMLIndex)
            end)
            local _, newFillTypeList = g_thSprayTypes:addExtendedSprayTypesToFillTypeList(stationFillTypes, nil, nil, true, true)
            if newFillTypeList ~= nil then
                for fillTypeId, newFillTypeData in pairs(newFillTypeList) do
                    local xtSprayTypeData = g_thSprayTypes:getExtendedSprayTypeByFillType(fillTypeId)
                    if xtSprayTypeData ~= nil and not xtSprayTypeData.isBaseType
                        and stationFillTypes[xtSprayTypeData.fillType.name] == nil
                    then
                        local fillTypeKey = string.format("%s.fillType(%d)", xmlKey, lastFillTypeXMLIndex)
                        local priceScale = THUtils.getNoNil(newFillTypeData.priceScale, defaultPriceScale)
                        local statsName = THUtils.getNoNil(newFillTypeData.statsName, defaultStatsName)
                        if statsName ~= nil or priceScale ~= nil then
                            wrappedXML:setString(fillTypeKey .. "#name", xtSprayTypeData.fillType.name)
                            if statsName ~= nil then
                                wrappedXML:setString(fillTypeKey .. "statsName", statsName)
                            end
                            if priceScale ~= nil then
                                wrappedXML:setFloat(fillTypeKey .. "#priceScale", priceScale)
                            end
                            if THUtils.getIsDebugEnabled() then
                                THUtils.displayMsg("BuyingStation: added fillType %q", xtSprayTypeData.fillType.name)
                                THUtils.displayMsg("- priceScale: %s", priceScale)
                                THUtils.displayMsg("- statsName: %s", statsName)
                            end
                            lastFillTypeXMLIndex += 1
                        end
                    end
                end
            end
        end
    end)
    return superFunc(parent, rootNode, xmlFile, xmlKey, ...)
end
function THLoadTrigger.gInj_load(superFunc, parent, rootNode, xmlFile, xmlKey, ...)
    THUtils.pcall(function()
        local wrappedXML = THUtils.wrapXMLFile(xmlFile)
        if wrappedXML ~= nil then
            local fillTypeNames = wrappedXML:getString(xmlKey .. "#fillTypes")
            local fillTypeCategories = wrappedXML:getString(xmlKey .. "#fillTypeCategories")
            if (fillTypeNames ~= nil and fillTypeNames ~= "")
                or (fillTypeCategories ~= nil and fillTypeCategories ~= "")
            then
                local newFillTypeNames = g_thSprayTypes:addExtendedSprayTypesToFillTypeList(fillTypeNames, fillTypeCategories, nil, true, true)
                if newFillTypeNames ~= nil then
                    if THUtils.getIsDebugEnabled() then
                        THUtils.displayMsg("LoadTrigger: updated fill types: %s", newFillTypeNames)
                    end
                    wrappedXML:setString(xmlKey .. "#fillTypes", newFillTypeNames)
                    if fillTypeCategories ~= nil then
                        wrappedXML:removeProperty(xmlKey .. "#fillTypeCategories")
                    end
                end
            end
        end
    end)
    return superFunc(parent, rootNode, xmlFile, xmlKey, ...)
end
THUtils.pcall(initScript)