-- Copyright 2024-2025 by Todd Hundersmarck (ThundR) 
-- All Rights Reserved

--[[

Unauthorized use and/or distribution of this work entitles myself, the author, to unlimited free and unrestricted use, access, and distribution of any works related to the unauthorized user and/or distributor.

--]]

local THStorage = {}
THSprayTypes.Storage = THStorage
local function initScript()
    THUtils.setFunctionHook("Storage", "load", false, false, nil, THStorage.gInj_load)
end
function THStorage.gInj_load(superFunc, parent, rootNode, xmlFile, xmlKey, ...)
    THUtils.pcall(function()
        local wrappedXML = THUtils.wrapXMLFile(xmlFile)
        if wrappedXML ~= nil then
            local fillTypeNames = wrappedXML:getString(xmlKey .. "#fillTypes")
            local fillTypeCategories = wrappedXML:getString(xmlKey .. "#fillTypeCategories")
            if (fillTypeNames ~= nil and fillTypeNames ~= "")
                or (fillTypeCategories ~= nil and fillTypeCategories ~= "")
            then
                local newFillTypeNames, newFillTypeList = g_thSprayTypes:addExtendedSprayTypesToFillTypeList(fillTypeNames, fillTypeCategories, nil, true, true)
                if newFillTypeNames ~= nil then
                    if THUtils.getIsDebugEnabled() then
                        THUtils.displayMsg("Storage: updated fill types: %s", newFillTypeNames)
                    end
                    wrappedXML:setString(xmlKey .. "#fillTypes", newFillTypeNames)
                    if fillTypeCategories ~= nil then
                        wrappedXML:removeProperty(xmlKey .. "#fillTypeCategories")
                    end
                    if newFillTypeList ~= nil then
                        local capacityBaseKey = xmlKey .. ".capacity"
                        if wrappedXML:hasProperty(capacityBaseKey) then
                            local lastCapacityXMLIndex = 0
                            local capacityFillTypes, maxCapacity = {}, -1
                            wrappedXML:iterate(capacityBaseKey .. ".capacity", function(pCapacityXMLIndex, pCapacityKey)
                                local fillTypeName = wrappedXML:getString(pCapacityKey .. "#fillType")
                                local capacity = wrappedXML:getFloat(pCapacityKey .. "#capacity")
                                if fillTypeName ~= nil and fillTypeName ~= ""
                                    and capacity ~= nil and capacity >= 0
                                then
                                    maxCapacity = math.max(maxCapacity, capacity)
                                    capacityFillTypes[fillTypeName:upper()] = capacity
                                end
                                lastCapacityXMLIndex = math.max(lastCapacityXMLIndex, pCapacityXMLIndex)
                            end)
                            if lastCapacityXMLIndex > 0 and maxCapacity >= 0 then
                                for fillTypeId in pairs(newFillTypeList) do
                                    if capacityFillTypes[fillTypeId] == nil then
                                        local xtSprayTypeData = g_thSprayTypes:getExtendedSprayTypeByFillType(fillTypeId)
                                        if xtSprayTypeData ~= nil then
                                            local capacityKey = string.format("%s.capacity(%d)", lastCapacityXMLIndex)
                                            local newCapacity = THUtils.getNoNil(capacityFillTypes[xtSprayTypeData.baseFillType.name], maxCapacity)
                                            if THUtils.getIsDebugEnabled() then
                                                THUtils.displayMsg("Storage: setting capacity of %q to %s", xtSprayTypeData.fillType.name, newCapacity)
                                            end
                                            wrappedXML:setString(capacityKey .. "#fillType", xtSprayTypeData.fillType.name)
                                            wrappedXML:setFloat(capacityKey .. "#capacity", newCapacity)
                                            lastCapacityXMLIndex = lastCapacityXMLIndex + 1
                                        end
                                    end
                                end
                            end
                        end
                    end
                end
            end
        end
    end)
    return superFunc(parent, rootNode, xmlFile, xmlKey, ...)
end
THUtils.pcall(initScript)