-- Copyright 2024-2025 by Todd Hundersmarck (ThundR) 
-- All Rights Reserved

--[[

Unauthorized use and/or distribution of this work entitles myself, the author, to unlimited free and unrestricted use, access, and distribution of any works related to the unauthorized user and/or distributor.

--]]

local thModPath = g_currentModDirectory
source(thModPath .. "shared/scripts/THCore.lua")
source(thModPath .. "shared/scripts/managers/THSpecManager.lua")
source(thModPath .. "shared/scripts/managers/THMapTypeManager.lua")
THPFConfig = {}
local THPFConfig_mt = Class(THPFConfig, THCore)
THPFConfig.NAME = "thPFConfig"
THPFConfig.CLASS_NAME = "THPFConfig"
THPFConfig.DEBUG_FLAG_ID = {
    PHMap = THUtils.createDebugFlagId("THPHMap")
}
local function initScript()
    local self = THPFConfig.new(THPFConfig.NAME)
    if self ~= nil then
        _G.g_thPFConfig = self
    end
end
function THPFConfig.new(name, customMt)
    customMt = customMt or THPFConfig_mt
    local self = THCore.new(name, customMt)
    if self ~= nil then
        local pfData = {
            modName = "FS25_precisionFarming",
            isFound = false,
        }
        self.precisionFarming = pfData
        return self
    end
end
function THPFConfig.onPreInit(self, ...)
    THUtils.callSuperClass(THPFConfig, "onPreInit", self, ...)
    local pfData = self.precisionFarming
    local modPath = self.coreData.mod.path
    pfData.isFound = false
    local pfModData = g_thModManager:getActiveMod(self.precisionFarming.modName)
    if pfModData ~= nil then
        local pfModEnv = pfModData.environment
        local PrecisionFarming = pfModEnv.PrecisionFarming
        if PrecisionFarming ~= nil then
            pfData.target = pfModEnv.g_precisionFarming
            pfData.mod = pfModData
            pfData.isFound = true
            source(modPath .. "modules/sprayTypes/scripts/THSprayTypes.lua")
            source(modPath .. "modules/tramlines/scripts/THTramlines.lua")
            source(modPath .. "modules/soilMap/scripts/THSoilMap.lua")
        end
    end
end
function THPFConfig.onPostInit(self, ...)
    THUtils.callSuperClass(THPFConfig, "onPostInit", self, ...)
    self:loadMapData()
end
function THPFConfig.onLoadMapFinished(self, mission, ...)
    THUtils.callSuperClass(THPFConfig, "onLoadMapFinished", self, mission, ...)
    if THUtils.getIsDebugEnabled() then
        local pfData = self.precisionFarming
        if pfData.isFound then
            THUtils.displayMsg("THPFConfig configuration:")
            THUtils.printTable(pfData)
        end
    end
end
THUtils.pcall(initScript)