--
-- SetTripComputerModeEvent
--
-- Author: Sławek Jaskulski
-- Copyright (C) Mod Next, All Rights Reserved.
--

SetTripComputerModeEvent = {}

local SetTripComputerModeEvent_mt = Class(SetTripComputerModeEvent, Event)

InitEventClass(SetTripComputerModeEvent, "SetTripComputerModeEvent")

---Create instance of Event class
-- @return table self instance of class event
function SetTripComputerModeEvent.emptyNew()
  local self = Event.new(SetTripComputerModeEvent_mt)

  return self
end

---Create new instance of event
-- @param table vehicle vehicle instance
-- @param number state trip computer mode state
-- @return table self instance of class event
function SetTripComputerModeEvent.new(vehicle, state)
  local self = SetTripComputerModeEvent.emptyNew()

  self.vehicle = vehicle
  self.state = state

  return self
end

---Called on client side on join
-- @param number streamId the stream id
-- @param table connection the connection instance
function SetTripComputerModeEvent:readStream(streamId, connection)
  self.vehicle = NetworkUtil.readNodeObject(streamId)
  self.state = streamReadUIntN(streamId, TripComputer.NUM_BITS)
  self:run(connection)
end

---Called on server side on join
-- @param number streamId the stream id
-- @param table connection the connection instance
function SetTripComputerModeEvent:writeStream(streamId, connection)
  NetworkUtil.writeNodeObject(streamId, self.vehicle)
  streamWriteUIntN(streamId, self.state, TripComputer.NUM_BITS)
end

---Run action on receiving side
-- @param table connection the connection instance
function SetTripComputerModeEvent:run(connection)
  if not connection:getIsServer() then
    g_server:broadcastEvent(self, false, connection, self.vehicle)
  end

  if self.vehicle ~= nil and self.vehicle:getIsSynchronized() then
    self.vehicle:setTripComputerMode(self.state, true)
  end
end

---Send event to server or broadcast to clients
-- @param table vehicle vehicle instance
-- @param number state trip computer mode state
-- @param boolean noEventSend if true, no event will be sent
function SetTripComputerModeEvent.sendEvent(vehicle, state, noEventSend)
  if vehicle ~= nil and vehicle.spec_tripComputer ~= nil and vehicle.spec_tripComputer.currentTripComputerMode ~= state and (noEventSend == nil or noEventSend == false) then
    if g_server ~= nil then
      g_server:broadcastEvent(SetTripComputerModeEvent.new(vehicle, state), nil, nil, vehicle)
    else
      g_client:getServerConnection():sendEvent(SetTripComputerModeEvent.new(vehicle, state))
    end
  end
end
