--
-- SpeedMeterDisplayExtension
--
-- Author: Sławek Jaskulski
-- Copyright (C) Mod Next, All Rights Reserved.
--

---Called when scaled values are stored for the speedometer display
SpeedMeterDisplay.storeScaledValues = Utils.appendedFunction(SpeedMeterDisplay.storeScaledValues, function(self)
  -- create and initialize display
  self.tripComputer = TripComputerDisplay.new()
  self.tripComputer:setVehicle(self.vehicle)
  self.tripComputer:setScale(self.uiScale)

  -- hide default working hours display
  self.workingHours:setVisible(false)
  self.seperatorWidth = 0
  self.workingHoursTextSize = 0
end)

---Called when drawing the speedometer display
SpeedMeterDisplay.draw = Utils.appendedFunction(SpeedMeterDisplay.draw, function(self)
  if self.vehicle ~= nil and self.isVehicleDrawSafe then
    -- calculate position centered below speedometer
    local centerX = self.speedBg.x + self.speedGaugeCenterOffsetX
    local offsetY = self:scalePixelToScreenHeight(2)
    local posX = centerX - (self.tripComputer.panelWidth * 0.5)
    local posY = self.speedBg.y + offsetY

    -- set position and render
    self.tripComputer:setPosition(posX, posY)
    self.tripComputer:draw()
  end
end)

---Called when setting vehicle for the speedometer display
SpeedMeterDisplay.setVehicle = Utils.appendedFunction(SpeedMeterDisplay.setVehicle, function(self, vehicle)
  local hasVehicle = vehicle ~= nil
  local isMotorized = hasVehicle and vehicle.spec_motorized ~= nil

  -- attach to motorized vehicles only
  if hasVehicle and isMotorized then
    self.tripComputer:setVehicle(vehicle)
  end
end)
