--
-- AdditionalSpecialization
--
-- Author: Sławek Jaskulski
-- Copyright (C) Mod Next, All Rights Reserved.
--

-- name of the mod
local modName = g_currentModName

-- specializations to add based on existing vehicle specializations
local additionalSpecsBySpecialization = {
  -- add trip computer to all motorized vehicles
  ["motorized"] = {
    modName .. ".tripComputer",
    modName .. ".tripComputerField",
  },
}

--
AdditionalSpecialization = {}

---Finalizes vehicle types
-- @param table self self
function AdditionalSpecialization.finalizeTypes(self)
  if self.typeName ~= "vehicle" then
    return
  end

  -- ensure mod is loaded and active before adding specializations
  if not g_modIsLoaded[modName] then
    return
  end

  -- iterate through all vehicle types
  for typeName, typeEntry in pairs(self:getTypes()) do
    -- iterate through existing specializations from end to start
    for specIndex = #typeEntry.specializationNames, 1, -1 do
      local currentSpecName = typeEntry.specializationNames[specIndex]

      -- check if this specialization should trigger additional specializations
      for baseSpec, additionalSpecs in pairs(additionalSpecsBySpecialization) do
        if currentSpecName == baseSpec then
          -- add each additional specialization if not already present
          for additionalSpecIndex = 1, #additionalSpecs do
            if typeEntry.specializationsByName[additionalSpecs[additionalSpecIndex]] == nil then
              self:addSpecialization(typeName, additionalSpecs[additionalSpecIndex])
            end
          end
        end
      end
    end
  end
end

---Called when finalizing vehicle types
TypeManager.finalizeTypes = Utils.prependedFunction(TypeManager.finalizeTypes, AdditionalSpecialization.finalizeTypes)
